package stream

// SourceID is an identifier that exists to distinguish the origin of a stream
// from other processes running the same stream so that clients can detect when
// a stream has changed over to a different source, allowing potential lost
// signals between deltas to be reported properly. This is not necessary if the
// source does not transmit deltas.
type SourceID uint32

const (
	None SourceID = 0
)
