package stream

// A Topic is extracted from an Audience so that ServerLogic can perform
// a sequence of updates without needing to resolve the destination each time.
//
// Unlike a Listener, each topic refers to a single concrete Address with a
// single Position.
type Topic interface {
	Address() Address
	Current() (SourceID, Position)
	Send(src SourceID, at Segment, data []byte) error
	Forward(Message) error
	Close(err error) error
}
