package ticket

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type Redeemer interface {
	Redeem(stream.AuthMethod, stream.OpaqueBytes) stream.CredentialsPromise
}

type emptyRedeemer struct{}

var empty = emptyRedeemer{}

// GetNilRedeemer returns a permissive redeemer that returns no information
func GetNilRedeemer() Redeemer { return empty }
func (emptyRedeemer) Redeem(stream.AuthMethod, stream.OpaqueBytes) stream.CredentialsPromise {
	return stream.NewSyncCredentialsPromise(stream.AllPermissions(), nil)
}
