package websocket

import (
	"context"
	"crypto/tls"
	"net/url"

	"code.justin.tv/devhub/lib-lifecycle/src/lifecycle"
	"code.justin.tv/devhub/e2ml/libs/session"
	"github.com/gobwas/ws"
)

func alwaysTrue() bool { return true }

func NewClientFactory(url *url.URL, settings *Settings) session.ClientFactory {
	mgr := lifecycle.NewManager()
	if settings.Lifecycle != nil {
		settings.Lifecycle.RegisterHook(mgr, func() error { mgr.ExecuteAll(); return nil })
	}
	linkSettings := newLinkSettings(ws.MaskFrame, settings)
	return func(bind session.Binding) (session.Client, error) {
		return newClient(url, bind, settings.Certs, mgr, linkSettings)
	}
}

func NewClientResolver(settings *Settings) session.ClientResolver {
	mgr := lifecycle.NewManager()
	if settings.Lifecycle != nil {
		settings.Lifecycle.RegisterHook(mgr, func() error { mgr.ExecuteAll(); return nil })
	}
	linkSettings := newLinkSettings(ws.MaskFrame, settings)
	return func(url *url.URL, bind session.Binding) (session.Client, error) {
		return newClient(url, bind, settings.Certs, mgr, linkSettings)
	}
}

func newClient(url *url.URL, bind session.Binding, certs *tls.Config, mgr lifecycle.Manager, settings *linkSettings) (session.Client, error) {
	conn, _, _, err := ws.Dialer{TLSConfig: certs}.Dial(context.Background(), url.String())
	if err != nil {
		bind.OnClosed(err)
		return nil, err
	}

	// create link
	link := newLink(settings, conn, mgr)

	mgr.RunUntilComplete(func() {
		var err error
		defer func() { bind.OnClosed(link.cause()) }()
		defer link.gracefulClose()
		defer func() { link.Close(err) }()

		err = execute(bind, link, ws.StateClientSide, alwaysTrue)
	})

	return link, nil
}
