package websocket

import (
	"code.justin.tv/devhub/e2ml/libs/errors"
	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/timeout"
)

type linkSettings struct {
	mask         maskFunc
	maxMsgLength int
	timeout      timeout.Sampler
	onTimeout    TimeoutBehavior
	errorMap     errors.Dictionary
	logger       logging.Function
}

func newLinkSettings(mask maskFunc, source *Settings) *linkSettings {
	settings := &linkSettings{
		mask:         mask,
		maxMsgLength: source.MaxMessageLength,
		timeout:      source.Timeout,
		onTimeout:    source.OnTimeout,
		errorMap:     source.ErrorMap,
		logger:       source.Logger,
	}
	if settings.logger == nil {
		settings.logger = logging.Noop
	}
	if settings.timeout == nil {
		settings.timeout = timeout.NewConstantSampler(defaultDuration)
	}
	if settings.errorMap == nil {
		settings.errorMap = errors.NewDictionaryBuilder().Build()
	}
	return settings
}
