# INACTIVE NOTICE

This service is no longer active. The AWS account and all resources have been removed.

# E2ML "message-prototype"

Prototype for extensions messaging system; includes mock-up of auth node, gateway, discovery, and routing services.

* E2ML Threat Model: https://docs.google.com/document/d/1iC7KGg4AHsh-usWQiNGeBJtFbySaJxyxJ6wQyOdr9eg/
* See [docs/architecture.md](./docs/architecture.md) for a high-level explanation of the different components.
* See [docs/repo.md](./docs/repo.md) for a description of repo contents and a jumping-off point for library descriptions
* See README on each service in the /services folder for the basic intended operation for each system.

## Development

Requirements:

 * Golang (use version in Dockerfile)
 * aws-cli-v2 (https://docs.aws.amazon.com/cli/latest/userguide/install-cliv2.html)
 * Docker

#### SSL Cert

Generate a self signed certificate. The services expect files `certs/service.crt` and `certs/service.key` to exist. The simplest way to generate a private key and self-signed certificate for localhost is with this openssl command (source https://letsencrypt.org/docs/certificates-for-localhost/):

```sh
$ openssl req -x509 -out service.crt -keyout service.key \
  -newkey rsa:2048 -nodes -sha256 \
  -subj '/CN=service' -extensions EXT -config <( \
   printf "[dn]\nCN=service\n[req]\ndistinguished_name = dn\n[EXT]\nsubjectAltName=DNS:service\nkeyUsage=digitalSignature\nextendedKeyUsage=serverAuth")

```

Then move to the certs folder:
```sh
$ mkdir certs
$ mv service.crt certs
$ mv service.key certs
```

#### Run in localhost

There are a series of scripts available to run a local stack for debugging purposes. It will run each service with defaults to connect to each other in localhost. For example, you can run the services from the terminal (one on each tab):

```sh
./scripts/service/pathfinder
./scripts/service/source
./scripts/service/greeter
./scripts/service/threshold
```

There are also some scripts to start clients to test the service in localhost, for example:

```sh
./scripts/client/chat
```

## Deploy

Deploys are currently done from your laptop.

#### Service Restarts

If you just need to restart the service, it is easier and safer to do a force-restart instead. See the docs/runbook.md for instructions.

#### Build Docker image

Make sure you are in the right branch and all changes are commited, because the image is tagged with the current git commit sha, which is later used by the deploy script:

 * master for production
 * any other branch for dev

Build scripts:

```sh
# Build all
make build clean

# Build only one service
./scripts/build_docker.sh greeter
./scripts/build_docker.sh pathfinder
./scripts/build_docker.sh threshold
./scripts/build_docker.sh source
```

#### Blue/Green Deploy

After building, deploy from your laptop with the script:
```sh
./scripts/push_docker.sh <env> <service>
```

Examples:

```sh
# Deploy to twitch-eml-prod profile (requires AWS credentials: mwinit, ada)
./scripts/push_docker.sh prod greeter
./scripts/push_docker.sh prod pathfinder
./scripts/push_docker.sh prod threshold
./scripts/push_docker.sh prod source
```

See docs/runbook.md for details on CloudWatch monitoring, autoprof profiles, making sure that there are no collisions, and restarting services.

#### Deploy services in order

To smooth any collision issues resulting from deploys, it is recommended to deploy in order:

 1. Greeter
 2. Pathfinder
 3. Threshold
 4. Source

For example, is Pathfinder is deployed/restarted, we should followup by deploying/restarting Threshold and Source, even if they don't have new changes.

## OnCall Runbook

[docs/runbook.md](./docs/runbook.md)
