package chat

import (
	"fmt"
	"strings"

	"code.justin.tv/devhub/e2ml/libs/logging"
)

type formatter struct {
	console logging.Console
}

func (f *formatter) onError(err error) {
	f.console.WriteError(fmt.Errorf("* %v", err))
}

func (f *formatter) onMessage(topic string, msg *message) {
	switch msg.Code {
	case "join":
		f.onJoined(topic, msg.User)
	case "leave":
		f.onLeft(topic, msg.User)
	case "send":
		f.onSent(topic, msg.User, msg.Content)
	}
}

func (f *formatter) onLogLevelSet(level logging.Level) {
	f.console.WriteLine(fmt.Sprintf("* logging set to %v", level))
}

func (f *formatter) onJoined(topic, user string) {
	f.console.WriteLine(fmt.Sprintf("* %s has joined [%s]", user, topic))
}

func (f *formatter) onLeft(topic, user string) {
	f.console.WriteLine(fmt.Sprintf("* %s has left [%s]", user, topic))
}

func (f *formatter) onSent(topic, user, content string) {
	f.console.WriteLine(fmt.Sprintf("[%s] %s: %s", topic, user, content))
}

func (f *formatter) onClosed(topic string) {
	f.console.WriteLine(fmt.Sprintf("* [%s] has been closed", topic))
}

func (f *formatter) printTopics(current string, topics []string) {
	out := "* not talking"
	if current != "" {
		out = fmt.Sprintf("* talking on [%s]", current)
	}
	f.console.WriteLine(fmt.Sprintf("%s, listening to [%s]", out, strings.Join(topics, "], [")))
}
