package setup

import (
	"time"

	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/extjwt"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/fake"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/s2s"
)

func NewAuthSource(clientID string, token, s2sSecret s2s.OpaqueBytes, expiration time.Duration, logger logging.Function) stream.AuthSource {
	if !s2sSecret.IsEmpty() {
		logger(logging.Info, "# Using s2s auth source")
		src, err := s2s.NewAuthSource(s2sSecret, "eml-client-chat", "eml-greeter")
		if err != nil {
			panic(err)
		}
		return src
	}
	if clientID != "" {
		if !token.IsEmpty() {
			logger(logging.Info, "# Using extjwt auth source with supplied token")
			return extjwt.NewAuthSource(clientID, func() extjwt.OpaqueBytes { return token })
		}
		logger(logging.Info, "# Using extjwt auth source with fake tokens")
		return extjwt.NewAuthSource(clientID, extjwt.NewFakeTokenCreator("*", []string{"*"}, []string{"*"}, expiration))
	}
	logger(logging.Info, "# Using fake auth source")
	return fake.NewAuthSource()
}
