package setup

import (
	"code.justin.tv/common/jwt"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type forChannel struct {
	Channel string `json:"channel_id"`
}

func NewBaseAddress(client string, token stream.OpaqueBytes) stream.Address {
	channel := "*"
	if fragment, err := jwt.Parse(token); err == nil {
		var ch forChannel
		var header struct{}
		if err = fragment.Decode(&header, &ch); err == nil && ch.Channel != "" {
			channel = ch.Channel
		}
	}
	if client == "" {
		client = "*"
	}
	addr, err := stream.NewAddress(stream.Namespace("ext"), 1, map[string]string{
		"a": "*",
		"c": channel,
		"e": client,
	})
	if err != nil {
		panic("Illegal base address: " + err.Error())
	}
	return addr
}
