package setup

import (
	"crypto/tls"
	"net/http"
	"net/url"
	"strings"
	"time"

	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/discovery/broker/deferred"
	httpbroker "code.justin.tv/devhub/e2ml/libs/discovery/broker/http"
	"code.justin.tv/devhub/e2ml/libs/logging"
)

func NewBroker(url *url.URL, tls *tls.Config, logger logging.Function) discovery.Broker {
	if strings.HasPrefix(url.Scheme, "ws") {
		logger(logging.Info, "# Using direct connection to", url)
		return deferred.NewBroker(url)
	}
	logger(logging.Info, "# Using", url, "for discovery")
	return httpbroker.NewBroker(url, http.Client{
		Transport: &http.Transport{TLSClientConfig: tls},
		Timeout:   5 * time.Second,
	}, logger)
}
