package setup

import (
	"fmt"
	"math/rand"
	"time"

	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/metrics"
	"code.justin.tv/devhub/e2ml/libs/setup"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

func init() {
	rand.Seed(time.Now().UnixNano())
}

type Config struct {
	metrics.GoArgSource                    // see struct for details
	Server              setup.URL          `default:"http://localhost:8000" help:"server url, use wss for Threshold (validation auth), or https for Greeter (reservation auth)"`
	Username            Username           `help:"name used in chat lines"`
	Log                 logging.Level      `default:"info" help:"logging level [trace,debug,info,warning,error]"`
	MetricsMethod       string             `arg:"--metrics-method" default:"none" help:"metrics method [none,logged]"`
	Insecure            bool               `help:"allow connection to insecure server; only for local testing"`
	ClientID            string             `arg:"--client-id,env:TWITCH_EXT_ID" help:"extjwt validation: extension id to use"`
	JWT                 stream.OpaqueBytes `arg:"env:TWITCH_EXT_JWT"            help:"extjwt validation: jwt to use (generates fake if not present)"`
	JWTDuration         time.Duration      `arg:"--jwt-duration" default:"30s"  help:"extjwt validation: duration for fake tokens"`
	S2SSecret           stream.OpaqueBytes `arg:"--s2s-secret,env:S2S_SECRET"   help:"s2s validation: secret to use for signing"`
}

type Username string

// support for go-arg automated read
func (u *Username) UnmarshalText(text []byte) error {
	if len(text) != 0 {
		*u = Username(text)
		return nil
	}
	*u = Username(fmt.Sprintf("<anon-%d>", rand.Intn(1000)))
	return nil
}
