package setup

import (
	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/metrics"
	"code.justin.tv/devhub/e2ml/libs/metrics/devnull"
	"code.justin.tv/devhub/e2ml/libs/metrics/logged"
)

func NewMetricsTracker(method string, src metrics.TagSource, logger logging.Function) metrics.Tracker {
	switch method {
	case "logged":
		logger(logging.Info, "# Piping metrics to logging system")
		tracker, err := logged.NewTracker("chat.", logging.Debug, logger)
		if err != nil {
			panic("Unable to set up logged metrics tracker: " + err.Error())
		}
		return tracker
	case "none":
		logger(logging.Info, "# Piping metrics /dev/null")
		return devnull.NewTracker()
	default:
		panic("Unknown metrics type: " + method)
	}
}
