package collider

import (
	"fmt"

	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type formatter struct {
	console logging.Console
}

func (f *formatter) onError(err error) {
	f.console.WriteError(fmt.Errorf("* %v", err))
}

// func (f *formatter) onLogLevelSet(level logging.Level) {
// 	f.console.WriteLine(fmt.Sprintf("* logging set to %v", level))
// }

func (f *formatter) onAdded(scope stream.AddressScope, id stream.SourceID) {
	f.console.WriteLine(fmt.Sprintf("* added %v:%v", scope, id))
}

func (f *formatter) onDropped(scope stream.AddressScope) {
	f.console.WriteLine(fmt.Sprintf("* dropped %v", scope))
}

// func (f *formatter) printTopics(current string, topics []string) {
// 	out := "* not talking"
// 	if current != "" {
// 		out = fmt.Sprintf("* talking on [%s]", current)
// 	}
// 	f.console.WriteLine(fmt.Sprintf("%s, listening to [%s]", out, strings.Join(topics, "], [")))
// }
