package collider

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/ticket"
)

type mockTicketStore struct{}

var _ ticket.Store = (*mockTicketStore)(nil)

func Store() ticket.Store { return &mockTicketStore{} }

func (*mockTicketStore) Close() error { return nil }
func (*mockTicketStore) Tick()        {}
func (*mockTicketStore) Request(stream.Credentials) (ticket.OpaqueBytes, error) {
	return nil, stream.ErrNotImplemented
}
func (*mockTicketStore) Redeem(stream.AuthMethod, stream.OpaqueBytes) stream.CredentialsPromise {
	return stream.NewSyncCredentialsPromise(nil, stream.ErrNotImplemented)
}
