package collider

import (
	"fmt"
	"strings"

	"code.justin.tv/devhub/e2ml/libs/logging"
)

type command func(args []string) (bool, error)

type parser struct {
	console  logging.Console
	commands map[string]command
	onError  func(error)
}

func newParser(console logging.Console, cmds map[string]command, onError func(error)) *parser {
	return &parser{console: console, commands: cmds, onError: onError}
}

func (p *parser) run() {
	var quit bool
	var msg string
	var err error
	for msg, err = p.console.ReadLine(); err == nil; msg, err = p.console.ReadLine() {
		if len(msg) > 0 {
			quit, err = p.parse(msg)
			if err != nil {
				p.onError(err)
			}
			if quit {
				break
			}
		}
	}
}

func (p *parser) parse(msg string) (bool, error) {
	if strings.HasPrefix(msg, "/") {
		segments := strings.Fields(msg)
		cmd := segments[0][1:]
		args := segments[1:]
		if command, ok := p.commands[cmd]; ok {
			return command(args)
		}
		return false, fmt.Errorf("Unknown command \"%s\"", cmd)
	}
	return false, fmt.Errorf("Unknown command \"%s\"", msg)
}
