package flock

import (
	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/session"
)

type node struct {
	client session.Client
	log    logging.Function
}

func NodeFactory(log logging.Function) session.BindingFactory {
	return func(client session.Client) session.Binding {
		log(logging.Info, "Node created", client.Address())
		return &node{client, log}
	}
}

func (n *node) OnTextMessage(msg string)     { n.log(logging.Info, "Text received:", msg) }
func (n *node) OnBinaryMessage(bytes []byte) { n.log(logging.Info, "Bytes received:", bytes) }
func (n *node) OnClosed(err error)           { n.log(logging.Info, "Node closed", n.client.Address(), err) }
