# EML Architecture

![Architecture Diagram](architecture_imgs/architecture_diagram.png)

### Services

 * **Threshold**: Edge for new connections. Authorizes the request using Greeter and routes requests/connections to a Source with available resources.
 * **Greeter**: Authorizes new connections, using a remote Validator (Extensions-Validator-Service) to sign JWT tokens. Used for validation auth.
 * **Pathfinder**: Finds a Source that has available resources. Monitors Sources to load balance new connections. Used for reservation auth.
 * **Source**: Routes messages in a given address and starts the fan out to the listeners.

### Alternative Architecture: Clients using Reservation auth

This was part of the original design for EML, and is worth mentioning for historical reasons (which help understand the code) and because this architecture may be a great option to escale EML to the next order of magnitude.

In this architecture, public clients would use the same Reservation auth flow that is working between Thresholds and Sources. Basically, Greeters would behave like Pathfinders; Validation auth would be done directly between clients and Greeters.

```
       Greeter    Pathfinder
      //   |     //     |
client => Threshold => Source
```

The main advantage of this architecture is that clients load can be properly balanced. A client would first connect to a Greeter (that would be behind a public LB), the Greeter would decide what is the best Threshold available to handle the new connection, making sure that all clients subscribing to the same channel go through the same Threshold, and give the client an authorization ticket with a Threshold IP address to connect, and stablish a connection stream with that Threshold.

The main disadvantange of this architecture is that Thresholds would be exposes publicly; they would need to handle strict security requirements, be able to terminate TLS (https) connections and know how to defend the system from DDoS attacks, which load balancers are usually taking care of.


### Alternative Architecture: Nested Discoverable Routing

Currently, clients and Thresholds are using the same registry library. This means, connecting to a Threshold is the same as connecting to a Source, which also means that Sources could be replaced by another layer of Thresholds, making a chain of Thresholds.

```
        Greeter    Pathfinder   Pathfinder   Pathfinder
           |      //    |      //    |      //    |
client => Threshold => Threshold => Threshold => Source
```

This architecture is explained in more detail in the overview design doc: https://docs.google.com/document/d/1It-hF10wE8H7CUCBgXHJkkSGKosrP6PS-qTHPt0SPcE/edit#

With this layout, the discovery and routing block is repeated with different discovery rules to form the message pipeline. The outermost layer performs client authorization checking for public access; the next layer could act as a regional cache, the next layer for central traffic routing, and the last one routing to the sources.
