# E2ML Addresses and Scopes

# Stream Addresses

E2ML message delivery is organized into "streams" of information; each stream has a multipart address that defines where it should be delivered: `<namespace>@<version>?<filter>`. Each of these components is meant to have a specific purpose in defining how and where a stream is stored and routed.

## Namespace
The namespace portion of the address is meant to define what architecural purpose the stream is providing. Many of the internal system metrics are broken out by namespace so that traffic and load can be properly attributed by use case. 

There are currently two namespaces in use: `ext` is for extension messaging and `loadtest` is used for the internal load testing system. One future use case would be `config` for live updates pushed by the Configuration Service. Generally speaking, each new system that pushes data into E2ML should be given a unique namespace.

## Version
The version field is provided as a way to provide a grace period of backward compatibility when the payload format for a namespace has changed.  For instance, if the Configuration Service needed to change its format and publish `config@2?...` streams, it should also serve the old protocol at `config@1?...` as deprecated for a grace period to allow all clients to transition.  This is important because some clients such as mobile and the desktop app may need to roll out on schedules that differ from the services that push the messages.  Serving both streams in parallel allows the new client code to be written without worring about old formats.  The servers should be updated before the new clients roll out, causing a zero downtime transition.  Once traffic on the old version has tailed off it is safe to remove support from the service.

## Filter
The filter portion of stream addresses is a series of key-value pairs like an HTTP query string. When combined, these filters are meant to provide a unique and easy to find location inside of the namespace/version pair for a given context.  

For example, the `ext` namespace uses the extension id (`e`), channel id (`c`), and intended audience (`a`) as values for sending data to a particular streamer's channel.  The audience field is currently always an asterisk to represent all viewers, but in the future streams could be built to allow access by role (such as subscriber-only data streams). Extension developers may want to add their own key-value pairs on top of the ones specified here (see discussion on dynamic naming below).

When a stream is declared, it can currently use up to 4 pairs; see discussion in [audience](audience.md) for more about why this limitation is in place and what can be done to increase the limit, allowing more powerful descriptions.

# Subscription Scopes

When writing to E2ML, it is necessary to pick a single stream address, but when asking for permissions or subscribing to E2ML it can be more convenient to refer to a collection of addresses instead of needing to list them individually.  This can be accomplished by removing keys from the filter portion of an address.  For instance, if a client is authorized to publish to all channels for an extension, its permission scope would be `ext@1?e=<ext>` instead of trying to explicitly declare a new address for all channels in advance (which is not practical).  In addition to being able to declare perissions with fewer filters to mean wider access control, there is a special wildcard scope `*` that is used to declare a service can provide all addresses.  This is used by the public edge of the system when clients connect. Since this wildcard does not contain the required components for an address, it is a virtual root and serves no actual traffic.

## Security and Required Filter Keys

In order to define safe sandboxes for message delivery, the security system in production will always return permissions with explicitly declared filters for each client connection--for instance, all extension messages will always need an extension id filter. These are considered "required" keys and any attempt to omit them will result in an `access_forbidden` error.

## Dynamic Naming

Let's say that a developer builds a LoL extension -- the base address for a given channel would be `ext@1?e=<ext>&c=<ch>&a=*` as noted above in the section on filters.  Let's say the extension wants to push live stat updates but also wants to include a history of gold advantage. As the game goes on, the unbounded list of historical gold values may overflow the maximum size allowed for a single stream.  The developer can use another filter to break the incoming data into multiple streams that describe the gold over time:
* `ext@1?e=<ext>&c=<ch>&a=*&t=live_data`
* `ext@1?e=<ext>&c=<ch>&a=*&t=gold_1`
* `ext@1?e=<ext>&c=<ch>&a=*&t=gold_2`
* `ext@1?e=<ext>&c=<ch>&a=*&t=gold_3`

If the historical data doesn't change over time (and it shouldn't), then only the live data and currently changing segment of the gold history needs to be broadcast to all viewers. The [history](history.md) system will automatically fill the historical gap for new users immediately, removing the majority of the traffic from the system while keeping the client feature performant.  This is cheaper for the servers and also better for viewers who don't need to continually re-download data that isn't actually changing.

In order to support this type of unbounded growth, it is possible to subscribe to a partial filter match; in this case if a user subscribes to the base address for the channel they will automatically receive all streams for that channel including new ones opened when the gold history expands.

Since the maximum amount of transmitted data scales linearly with the number of messages, we should build rate limiters on base addresses and give each base address a maximum number of subaddresses that it can serve. The first number limits the impact of traffic on both our system and viewers, and the second number is useful to limit the total storage required by the system. It's worth noting that in practice E2ML message servers only take dozens of megabytes of memory under our current production load, so offering additional 5KB blocks of message buffer looks viable.