# E2ML Audience

The `stream/audience` library provides an interface for serving E2ML messages over asynchronous I/O. This interface has an [API component](../../libs/stream/audience.go) and also requires registration of an [event handler](../../libs/stream/server_logic.go) for responding to client requests. There are currently two servers, [Threshold](../../services/threshold/server.go) and [Source](../../services/source/server.go), that share this library.  The primary state machine for the library is a class named `remote`.

When a client connects to the library, it is captured by a session `binding` object and the system waits for it to be authorized by calling a [ticket redeemer](../../libs/ticket/redeemer.go) that either verifies a pre-validated ticket or requests inline credential verification depending on the content of the client request.  After authorization has completed, an additional `client_listener` object is created to handle the business logic for the session. Dividing the logic between binding and listener strictly enforces the need for authorization before normal traffic flow.

After connection and authorization, the client can attempt to send messages or subscribe to [scopes](address.md). Each unique scope is associated with a `channel` object that reference counts the attached listeners and writers.

In order to support subscriptions by partial filters, the `channel` graph stores links to any address that adds or removes one filter element for easy navigation.  These links are automatically generated when the more specific `channel` is created by the `remote` object.  When a message is pushed to clients, the `channel` automatically calls all of its parents to recursively perform the publish operation; this means that a subscriber to `ext@1?e=12&c=abc` will receive the message sent to `ext@1?e=12&c=abc&t=value` automatically. When a new subscription is added to the graph, all descendents of the address are visited to push history to the viewer as if they had been previouly listening. Since the graph walk is bidrectional, there are links established both ways in the `channel` struct.

Channel resources are reclaimed when the reference count of listeners, count of writers, and count of "child" scopes are all zero, meaning a service that has no collected clients will reclaim all stuctures and return to having am empty set of `channel` objects.

Each attempt to send a message is associated with a send `receipt` that acts as a completion callback; this allows asynchronous message processing with an immediate response to the client on completion.