# Authorization

### Node Types

E2ML services consider other services depending on their node type:

 * **Client**: incoming requests for message subscriptions and/or writing new messages into the system.
 * **Host**: accepts subscriptions and serves messages back to clients. In a chain architecture (not implemented) it would also be able to forward messages to another host down the chain.
 * **Discovery**: balances hosts, decides what addresses are handled on each host, and performs all authorizations discussed below.

For example, for a given Threshold, the connected public client (extension) is a `Client`, Greeter as is a `Discovery` node used for for Validation auth, Pathfinder is a `Discovery` node used for Reservation auth, and Source is a `Host`.

```
 public => Threshold  => Source
             |      \\      |
          Greeter    Pathfinder
```

Looking at the symbols in the ascii diagram, we can notice 3 types of connections:

 * `|` Discovery connections over web sockets. They need s2s authorization when established, and then are used to validate auth tokens (Greeter), or distribute load over sources (Pathfinder).
 * `\\` Discovery HTTP calls to do custom load-balancing and generate auth tickets. The s2s authorization is done with an `Authorization` header that has a Bearer token with the signed JWT. Only used between Threshold and Pathfinder. In the future, if the architecture is expanded to be multi-layer, then nested sources would also use the same HTTP calls to get tickets for the nested layers.
 * `=>` Streams; Websockets over TLS/SSL between a client (left side) and a service (right side). Once the connection is established and validated (initial handshake), all messages will flow without overhead. The public connection to Threshold is authorized through Greeter. Threshold => Source also uses s2s.

### Auth flows

 * **Validation**: (public => Threshold) used to authorize clients when connecting to hosts behind traditional load balancers. On connection, the client sends a token to the host that is forwarded to the discovery system for authorization. For example, an Extension connects with wss through the public NLB (network load balancer), sending a extjwt token, Threshold validates that token by calling Greeter. When credentials are about to expire, the system will reuse the Validation style auth to renew the connection.
 * **Reservation**: (Threshold => Source) used to authorize clients when making direct connections to hosts. The client (e.g. Threshold) sends an HTTP request to the discovery system. After authorization, the discovery system selects a host; the host generates a ticket that is passed back to the client along with the address of the host for direct connection. The client redeems the ticket with the host on connection to complete the authorization process. For example, Threshold calls Pathfinder which picks a Source to generate a ticket; Threshold then uses the ticket on connection to the same Source instance.
 * **AuthHost**: (Threshold | Greeter, Source | Pathfinder) used to authorize host connections to the discovery system; executed once on initial connection. Example: Source connects to Pathfinder and sends a JWT signed with a shared secret. Now that the Source is trusted, it will be included in the Reservation flow.


## Auth Implementations

An `AuthRequest` represents a colletion of raw data required to generate `Credentials` for use of stream libraries. It should be passed to a Broker when attempting to FindHost so that proper security decisions can be made based on the permissions in the resulting credentials.

In our code, `AuthRequest` is an interface that allows arbitrary security models, it must be cast by the correct Resolver before use. The Method() functions attached to all of the auth interfaces are to be used as a hint system that can route a request to the matching system that actually understands the implementation. A failure to decode means no resolver will be called; it would be a waste of resources to try calling resolvers without decoded data.

Implementations:

 * **ExtJWT**: Interprets Extension JWTs (same auth used by Twitch Extensions) and forwards them to the extension-validator-service to verify signatures.
 * **S2S**: Our implementation of s2s uses JWT tokens, encoded with the `HS512` algorithm (NOTE: this is not twitch-s2s2). Both sender and receiver services are passed the secret at startup through environment variables (and using AWS secrets manager); the task definition uses the secret store as the safe origin of the data. This works with a symmetric key, using the same *secret* in both the sender and the receiver. The sender builds the JWT with some claims, signs it with the secret, and sends the signed token in the connection/request. The receiver validates the signature with the same secret.
 * **Composite**: combines other auth systems sequentially. For example, production uses extjwt auth for extensions and s2s auth for load tests.
 * **Empty**: allow handling anonymous access.
 * **Fake**: useful for testing and debugging.

## Some more design notes

Karl's original design for EML only had custom load balancing because standard connection balancing is a bad predictor of actual service load; when Thomas advised that an NLB should be put in front of Threshold for security reasons, that forced the creation of the second message flow using the existing status connection between discovery and messaging as authorization pathway after the NLB makes the load balancing decision. Instead of connecting with an already authorized and reserved connection slot, users are now connecting without any context and being authorized by the discovery layer as the first step of the handshake.

The discovery system can operate in two modes:

 * Use http with Extractor to load balance the message node.
 * Use the status websocket between the message node and the discovery node with Decoder to use a conventional load balancer, using the discovery system for authentication only.

