# E2ML History and Replay

In addition to pushing messages to subscribers as they occur, E2ML is designed to have a short memory for each [stream](address.md) that allows automatic replay when a client connects. Every subscription request includes the last known position that client saw for the requested stream (or position 0 if the client doesn't have that information), and if the system has more recent data it is automatically forwarded on connection.

## Deltas and Loss Detection

In addition to automatically replaying data that a client hasn't seen on connection, the system is also capable of sending a notification when an element in the message sequence has been dropped. The listener API has a callback for the client to take application specific action if the system determines that information is missing. As an optimization, however, a user can specify that a message is not a delta--when that is true, the system understands that no actual information has been lost by having a sequence gap and no notification of data loss is forwarded. Systems that are built this way do not need to implement a loss handler.

## Buffer Depth and Timeout Limitations

The current implementation of history uses a single cell buffer to record the last seen message for each stream, but in use cases where we know deltas are going to be used it may be better to include a deeper buffer of messages with either a static count or a static maximum size to improve the chances of recovery without loss.  The current implementation of the source service holds histories in memory for a configurable time (default 5 minutes) after all registered interest has stopped so that sporadic connections can still replay what occured last. As long as there is a writer attached to the address, the buffer will not clear.