# E2ML Registry

The `stream/registry` library implements an asynchronous I/O interface with automatic session management for receiving E2ML messages. The [api](../../libs/stream/registry.go) supports asynchronous requests for reader and writer sub-interfaces based on stream [addresses](address.md).  These interfaces supply asynchronous subscription and message insertion calls to allow clients to communicate bidirectionally.

Internally, the registry reference counts subscriptions and writers by address using a struct named `channel`.  Each channel is created or destroyed dynamically based on what the library user has requested; as long as there is at least one reader or writer active, the channel is persisted in memory regardless of the current session state.

This state machine and related data are contained in a struct named `remote` -- this class serves as a message hub that routes all inbound messages to the appropriate `channel` structs for processing.

When asked to listen or write on an address that isn't currently bound to a session, the registry will call an application provided [discovery](discovery.md) broker to look up an appropriate source. There are distinct implementations of the broker interface that represent two key strategies for server lookup: direct connection to multple [discovered](discovery.md) servers dynamically managed by the registry, or a single proxied connection to a load balanced cluster. In production, the load balanced mode is used by `client<->threshold` sessions and the dynamic discovery mode is used by `threshold<->source` sessions. Both the golang and typescript reference clients can operate in either mode:
* use `scripts/client/chat` to connect directly to a single edge server on your laptop
* use the `hello world` sample with url `wss://localhost:8001` to connect directly to a single Threshold server (like clients do in production through a Load Balancer).
* use the `hello world` sample with url `https://localhost:8000` to use discovery (using Greeter as Discovery, using reservation auth. Not used in production).

When discovery returns a new server URL, the registry injects that URL and proposed scope into a state machine tracking session lifecycles.  The state machine has three distinct phases: connecting, connecteed, and draining.
* Connected servers represent available and active address sources, and are the preferred locations for new address requests.  A `binding` object representing the client side of this session is created during this phase. It is described in more detail below.
* Connecting servers will be automatically selected for new addresses instead of using discovery if a connected server can't provide a match. These servers are converted to the connected state after a successful initialization handshake.
* Draining servers represent resources that are in the process of shutting down; they can't accept new connections but will continue serving old ones until the addresses have been remapped to live servers, allowing a handoff without dropping messages.  The registry automatically debounces duplicate messages sent over a draining and connected server pair.

The `binding` object handles message marshalling and unmarshalling, and is maintained in a 1:1 relationship with server sessions. Inbound signals trigger callbacks bound to the primary `remote` object for distribution to a `channel`.  The binding is also responsible for manually tracking request durations and firing timeouts when a request has been dropped (e.g. due to a session close).

Once a session has moved to the connected state, the `binding` object is applied to the `channel` for every associated address. Any listener or writer requests that were blocked waiting for an established session are executed at this point, and the channel will continue to execute asynchronous subscription and message push requests as needed. When a session is lost (e.g. due to a broken TCP connection) the session to address dictionary is consulted to see which addresses need to be rebound.  This allows the registry to automatically heal any broken connections.

