# Repistory Layout

* `.vscode` - local debugging tool data
* `certs` (ignored by git) -- X.509 certificate storage for running the services locally
* `clients` - source code for reference client and debugging tools
    * `chat` - reference client for `registry` library; can also connect to live environments
    * `collider` - client for `discovery` library used to test collision recovery
    * `flock` - reference client for `peering` library
    * `listener` - debug tool that can listen to a single address
    * `writer` - debug tool that can write to a single address
* `docs` - information deposit
    * `design` - plain english descriptions of the intent behind important library designs
* `libs` - source code for E2ML components
    * `discovery` - see [discovery.md](design/discovery.md) library responsible for message routing and source election
        * `broker` - implementations of message routing
            * `balanced` - `Broker` interface as a peered service; used by pathfinder and greeter services
                * `pick` - implementation of a weighted pick list used to efficiently route connection requests while balancing load
            * `deferred` - `Broker` interface with a hardcoded destination and remote auth; used for automatically load balanced targets
            * `http` - `Broker` interface as a http proxy; used for manually balancing direct connection targets
            * `static` - `Broker` interface with a hardcoded destination and local auth; for unit tests only
        * `election` - implementation of [PAXOS](https://en.wikipedia.org/wiki/Paxos_(computer_science)) used to choose which host should be the source of a given address
        * `host` - library used to send status information about an address source to a `balanced` broker
        * `protocol` - binary message format used to communicate between `host` and the `balanced` broker cluster
            * `message` - implementations of messages and their serializations in binary format
        * `service` - library used to receive requests from `http` `Broker` proxy; intended to wrap and serve an implementation dependent `Broker`
            * `api` - calls supported by the http service
            * `auth` - authorization middleware used by the http service
            * `data` - binding point for the http service to be tied to a specified `Broker`
    * `errors` - library supporting efficient serialization of error instances over the wire to allow equality checking by value; supports parameterized errors with intelligent http status detection
    * `http` - service adapter around golang `http.Serve` function (see [session.md]); also contains standardized serialization for JSON endpoints and errors
        * `params` - library used to pull query and body information from `http` requests into a context object
    * `logging` - abstraction layer used to wrap an implementation dependent logging source; provides ability to set verbosity level for each message sent
    * `metrics` - abstraction layer used to wrap an implementation dependent mestrics source
        * `twitchtelemetry` - metrics implementation using CloudWatch with TwitchTelemetry
        * `devnull` - metrics implementation that drops data
        * `logged` - metrics implementation that periodically logs current values; useful for local debugging
    * `peering` - adapter for converting symmetrical business logic into a peer-to-peer application; requires the  implementation to provide factories for starting listeners and clients. Used by the `balanced` broker
        * `dns` - implementation of peering logic that uses DNS queries to find peers
        * `hardcoded` - implementation of peering logic that uses a hardcoded list to "find" peers
    * `promise` - utilities that allows goroutines to block until a piece of data is made available; wraps `sync.Waiter`
    * `session` - abstraction of the transport between a client and a service; useful for creating debug harnesses
        * `devnull` - service that drops input; useful for testing session implementations
        * `echo` - service that echos input; useful for testing session implementations
    * `setup` - common components used to configure the `service` processes; this is really a grab bag of elements to reuse because there were too many requirement differences for a common entry point harness
    * `stream` - the core concepts of E2ML functionality, defining interfaces for streams, addresses, messages, credentials, and other critical types
        * `audience` - library used by servers to serve messages (see [audience.md](design/audience.md))
        * `auth` - responsible for all E2ML authorization code; abstracts translation of an AuthRequest into a Credential
            * `composite` - implentation of auth interfaces that attempts to use multiple internal auth systems sequentially, e.g. production uses `extjwt` auth for extensions and `s2s` auth for load tests.
            * `empty` - implemenation of auth interfaces to handle anonymous access
            * `extjwt` - implementation of auth interfaces that interprets extension JWTs and forwards them to the extension validator service to verify signatures
            * `fake` - implementation of auth interfaces with a hardcoded return; useful for testing and debugging
            * `s2s` - implementation of auth interfaces that uses a shared secret to sign and verify JWTs between services
        * `history` - offers rate limited and unlimited implementations of single-cell memory for data streams
        * `listener` - utilities for handling stream listeners
        * `protocol` - binrary protocol used to communicate between the `audience` and `registry` libraries
            * `message` - implementations of messages and their serializations in binary format
                * `marshal` - per-message caching of serialized formats; important optimization when fanning out to an audience of thousands
        * `registry` - library used by clients to receive messages (see [registry.md](design/registry.md))
        * `scheduler` - abstraction of fanout strategy used for delivering messages to large audiences; optimization work in this direction was not completed as of 2/20
    * `ticket` - interface for `http` broker to supply one-time codes authorizing direct connection access to address hosts; allows manual load balancing by only accepting pre-approved clients
        * `counting` - simple, fast ticket implementation for debugging only
        * `jwt` - secure ticket implementation; each service instance provides a unique signing secret so that tickets don't authorize the wrong connection
    * `timeout` - provides optionally jittered timeout values on reads to detect dead connections
    * `websocket` - implementation of `session` built using websockets
* `scripts` -  executable scripts that should be run from project root; both local execution and deploy scripts live here
* `services` - entry points and custom business logic for all of the E2ML services live here
    * `echo` - simply returns all input; useful for debugging the `websocket` library
    * `greeter` - responsible for client authorization
    * `pathfinder` - performs address routing from threshold to source
    * `source` - holds current state for addresses and fans out to tresholds
    * `threshold` - provides public connection edge, forwards messages from sources to clients
* `vendor` - golang code dependencies
