package broker

import (
	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/promise"
)

type asyncTicketPromise struct {
	src promise.MutableAny
}

func NewAsyncTicketPromise() discovery.MutableTicketPromise {
	return &asyncTicketPromise{promise.NewAny()}
}

func (a *asyncTicketPromise) WouldBlock() bool          { return a.src.WouldBlock() }
func (a *asyncTicketPromise) Get() (interface{}, error) { return a.src.Get() }
func (a *asyncTicketPromise) Result() (discovery.Ticket, error) {
	result, err := a.src.Get()
	if cast, ok := result.(discovery.Ticket); ok || result == nil {
		return cast, err
	}
	return nil, protocol.ErrInvalidCacheEntry
}

func (a *asyncTicketPromise) Set(result discovery.Ticket, err error) {
	a.src.Set(result, err)
}
