package broker

import (
	"errors"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestAsyncTicketPromise(t *testing.T) {
	expected := errors.New("expected")
	data := NewTicket("test", stream.Reservation, stream.OpaqueBytes("admit one"), stream.AddressScopes{})

	t.Run("should store a value", func(t *testing.T) {
		a := NewAsyncTicketPromise()
		assert.True(t, a.WouldBlock())
		assert.NotPanics(t, func() {
			a.Set(data, nil)
		})
		assert.False(t, a.WouldBlock())
		result, err := a.Result()
		assert.Equal(t, data, result)
		assert.NoError(t, err)
		val, err := a.Get()
		assert.Equal(t, data, val)
		assert.NoError(t, err)
	})

	t.Run("should store the first value", func(t *testing.T) {
		a := NewAsyncTicketPromise()
		assert.True(t, a.WouldBlock())
		assert.NotPanics(t, func() {
			a.Set(data, expected)
			a.Set(data, nil)
		})
		assert.False(t, a.WouldBlock())
		result, err := a.Result()
		assert.Equal(t, data, result)
		assert.Equal(t, expected, err)
	})

	t.Run("should explicitly handle an invalid value", func(t *testing.T) {
		a := NewAsyncTicketPromise().(*asyncTicketPromise)
		assert.NotPanics(t, func() {
			a.src.Set(1, nil) // illegal set
		})
		result, err := a.Result()
		assert.False(t, a.WouldBlock())
		assert.Nil(t, result)
		assert.Equal(t, protocol.ErrInvalidCacheEntry, err)
	})
}
