package balanced

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/broker"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
)

type allocData map[protocol.RequestID]broker.ScopesCallback
type allocMap struct {
	recent allocData
	old    allocData
}

func newAllocMap() *allocMap {
	return &allocMap{make(allocData), make(allocData)}
}

func (a *allocMap) add(req protocol.RequestID, callback broker.ScopesCallback) {
	a.recent[req] = callback
}

func (a *allocMap) remove(req protocol.RequestID) (broker.ScopesCallback, bool) {
	if p, ok := a.recent[req]; ok {
		delete(a.recent, req)
		return p, true
	}
	if p, ok := a.old[req]; ok {
		delete(a.old, req)
		return p, true
	}
	return nil, false
}

func (a *allocMap) tick() allocData {
	prev := a.old
	a.old = a.recent
	a.recent = make(allocData)
	return prev
}
