package balanced

import (
	"sync/atomic"
	"unsafe"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol/message"
)

// used to hold live traffic during initialization
type forwardingQueue struct {
	elements unsafe.Pointer
}

func newForwardingQueue() *forwardingQueue {
	empty := []message.Forward{}
	return &forwardingQueue{unsafe.Pointer(&empty)}
}

func (q *forwardingQueue) append(msg message.Forward) bool {
	for {
		val := atomic.LoadPointer(&q.elements)
		updated := append(*(*[]message.Forward)(val), msg)
		if atomic.CompareAndSwapPointer(&q.elements, val, unsafe.Pointer(&updated)) {
			return true
		}
	}
}

func (q *forwardingQueue) Flush() []message.Forward {
	updated := []message.Forward{}
	for {
		val := atomic.LoadPointer(&q.elements)
		if atomic.CompareAndSwapPointer(&q.elements, val, unsafe.Pointer(&updated)) {
			return *(*[]message.Forward)(val)
		}
	}
}
