package balanced

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type promiseData map[stream.AddressKey]*asyncHostPromise
type hostPromiseMap struct {
	recent  promiseData
	expired promiseData
}

func newHostPromiseMap() *hostPromiseMap {
	return &hostPromiseMap{make(promiseData), make(promiseData)}
}

func (h *hostPromiseMap) findOrAdd(addrKey stream.AddressKey) (*asyncHostPromise, bool) {
	if p, ok := h.recent[addrKey]; ok && !p.IsDone() {
		return p, false
	}
	if p, ok := h.expired[addrKey]; ok && !p.IsDone() {
		// Note: Do not refresh timer. Allow expiration even when in progress because we have a continuous
		// stream of requests and we need to allow these to go stale regardles of traffic
		// h.recent[addrKey] = p
		// delete(h.expired, addrKey) // refresh timer
		return p, false
	}
	p := newAsyncHostPromise()
	h.recent[addrKey] = p
	return p, true
}

func (h *hostPromiseMap) find(addrKey stream.AddressKey) (*asyncHostPromise, bool) {
	if p, ok := h.recent[addrKey]; ok {
		return p, true
	}
	if p, ok := h.expired[addrKey]; ok {
		return p, true
	}
	return nil, false
}

func (h *hostPromiseMap) tickExpire() promiseData {
	prev := h.expired
	h.expired = h.recent
	h.recent = make(promiseData)
	return prev
}
