package pick

import "code.justin.tv/devhub/e2ml/libs/stream"

type Entry interface {
	Host() Host
	Source() stream.SourceID
}

type pickEntry struct {
	host   Host
	source stream.SourceID
	score  uint64
	weight uint64
}

func newEntry(host Host, source stream.SourceID, score, weight uint64) *pickEntry {
	return &pickEntry{host: host, source: source, score: score, weight: weight}
}

func (p *pickEntry) Host() Host              { return p.host }
func (p *pickEntry) Source() stream.SourceID { return p.source }
func (p *pickEntry) refresh()                { p.score = statusToScore(p.host.Status()) }
func (p *pickEntry) clone() *pickEntry       { return newEntry(p.host, p.source, p.score, p.weight) }
func (p *pickEntry) balance(target uint64, scale int) int64 {
	if p.score == noScore || p.score > target {
		p.weight = noScore
	} else {
		p.weight = (target - p.score) >> scale
	}
	return int64(p.weight)
}
