package pick

import (
	"net"

	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol/message"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type Host interface {
	Hostname() string
	Allocate(stream.Address) discovery.ScopesPromise
	Detach(stream.Address)
	Reserve(stream.Credentials, stream.Address) discovery.TicketPromise
	Status() message.Status
	RemoteAddress() net.Addr
}
