package balanced

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/broker"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
)

type requestData map[protocol.RequestID]broker.TicketCallback
type requestMap struct {
	recent requestData
	old    requestData
}

func newRequestMap() *requestMap {
	return &requestMap{make(requestData), make(requestData)}
}

func (r *requestMap) add(req protocol.RequestID, callback broker.TicketCallback) {
	r.recent[req] = callback
}

func (r *requestMap) remove(req protocol.RequestID) (broker.TicketCallback, bool) {
	if p, ok := r.recent[req]; ok {
		delete(r.recent, req)
		return p, true
	}
	if p, ok := r.old[req]; ok {
		delete(r.old, req)
		return p, true
	}
	return nil, false
}

func (r *requestMap) tick() requestData {
	prev := r.old
	r.old = r.recent
	r.recent = make(requestData)
	return prev
}
