package deferred

import (
	"net/url"

	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/discovery/broker"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type brokerImpl struct {
	url *url.URL
}

func NewBroker(url *url.URL) discovery.Broker {
	return &brokerImpl{url}
}

func (b *brokerImpl) FindHost(auth stream.AuthRequest, addr stream.Address) (discovery.Ticket, error) {
	return b.createTicket(auth, addr)
}

func (b *brokerImpl) createTicket(auth stream.AuthRequest, addr stream.Address) (discovery.Ticket, error) {
	if auth == nil {
		return nil, stream.ErrMissingAuthorization
	}
	return broker.NewTicket(b.url.String(), stream.Validation, auth.Encode(), stream.AddressScopes{stream.AnyAddress}), nil
}
