package deferred

import (
	"net/url"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/broker"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/empty"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestBroker(t *testing.T) {
	host, err := url.Parse("wss://edge")
	require.NoError(t, err)
	addr, err := stream.NewAddress(stream.Namespace("n"), stream.Version(1), nil)
	require.NoError(t, err)

	ticket := broker.NewTicket(host.String(), stream.Validation, nil, stream.AddressScopes{stream.AnyAddress})

	t.Run("should serve input data and error synchronously", func(t *testing.T) {
		d, err := NewBroker(host).FindHost(empty.NewRequest(), addr)
		assert.Equal(t, ticket, d)
		assert.Nil(t, err)
	})

	t.Run("should require a request ticket", func(t *testing.T) {
		d, e := NewBroker(host).FindHost(nil, addr)
		assert.Nil(t, d)
		assert.Equal(t, stream.ErrMissingAuthorization, e)
	})
}
