package broker

import (
	"errors"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestIndirectTicketPromise(t *testing.T) {
	expected := errors.New("expected")
	data := NewTicket("test", stream.Reservation, stream.OpaqueBytes("admit one"), stream.AddressScopes{})
	inner := NewStaticTicketPromise(data, expected)

	t.Run("should store a promise", func(t *testing.T) {
		i := NewIndirectTicketPromise()
		assert.True(t, i.WouldBlock())
		assert.NotPanics(t, func() {
			i.Set(inner)
		})
		assert.False(t, i.WouldBlock())
		result, err := i.Result()
		assert.Equal(t, data, result)
		assert.Equal(t, expected, err)
		val, err := i.Get()
		assert.Equal(t, data, val)
		assert.Equal(t, expected, err)
	})

	t.Run("should store the first value", func(t *testing.T) {
		i := NewIndirectTicketPromise()
		assert.True(t, i.WouldBlock())
		assert.NotPanics(t, func() {
			i.Set(inner)
			i.Set(NewStaticTicketPromise(data, nil))
		})
		assert.False(t, i.WouldBlock())
		result, err := i.Result()
		assert.Equal(t, data, result)
		assert.Equal(t, expected, err)
	})

	t.Run("should explicitly handle a nil value", func(t *testing.T) {
		i := NewIndirectTicketPromise()
		assert.NotPanics(t, func() {
			i.Set(nil) // illegal set
		})
		result, err := i.Result()
		assert.False(t, i.WouldBlock())
		assert.Nil(t, result)
		assert.Equal(t, protocol.ErrInvalidCacheEntry, err)
	})
}
