package static

import (
	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type brokerImpl struct {
	resolver auth.Resolver
	ticket   discovery.Ticket
	err      error
}

func NewBroker(resolver auth.Resolver, ticket discovery.Ticket, err error) discovery.Broker {
	return &brokerImpl{resolver, ticket, err}
}

func (b *brokerImpl) FindHost(auth stream.AuthRequest, _ stream.Address) (discovery.Ticket, error) {
	if _, err := b.resolver.Resolve(auth); err != nil {
		return nil, err
	}
	return b.ticket, b.err
}
