package static

import (
	"errors"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/broker"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/empty"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/extjwt"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/fake"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestBroker(t *testing.T) {
	addr, err := stream.NewAddress(stream.Namespace("n"), stream.Version(1), nil)
	require.NoError(t, err)

	ticket := broker.NewTicket("url", stream.Validation, stream.OpaqueBytes("Admit One"), stream.AddressScopes{stream.AnyAddress})
	err = errors.New("expected")

	t.Run("should serve input data and error synchronously", func(t *testing.T) {
		b := NewBroker(empty.NewResolver(), ticket, err)
		d, e := b.FindHost(empty.NewRequest(), addr)
		assert.Equal(t, ticket, d)
		assert.Equal(t, err, e)
	})

	t.Run("should require a request ticket", func(t *testing.T) {
		b := NewBroker(extjwt.NewResolver(extjwt.NewFakeValidator(0, 0, nil)), ticket, err)

		d, e := b.FindHost(nil, addr)
		assert.Nil(t, d)
		assert.Equal(t, stream.ErrInvalidAuthMethod, e)
	})

	t.Run("should require a matching request ticket", func(t *testing.T) {
		b := NewBroker(empty.NewResolver(), ticket, err)

		d, e := b.FindHost(fake.NewRequest(), addr)
		assert.Nil(t, d)
		assert.Equal(t, stream.ErrExpectedAnonymousRequest, e)
	})
}
