package broker

import (
	"errors"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestStaticTicketPromise(t *testing.T) {
	expected := errors.New("expected")
	data := NewTicket("test", stream.Reservation, stream.OpaqueBytes("admit one"), stream.AddressScopes{})

	s := NewStaticTicketPromise(data, expected)
	assert.False(t, s.WouldBlock())
	result, err := s.Result()
	assert.Equal(t, data, result)
	assert.Equal(t, expected, err)
	val, err := s.Get()
	assert.Equal(t, data, val)
	assert.Equal(t, expected, err)
}
