package broker

import (
	"code.justin.tv/devhub/e2ml/libs/discovery"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type ticket struct {
	url    string
	method stream.AuthMethod
	code   stream.OpaqueBytes
	scopes stream.AddressScopes
}

var _ discovery.Ticket = (*ticket)(nil)

func NewTicket(url string, method stream.AuthMethod, code stream.OpaqueBytes, scopes stream.AddressScopes) discovery.Ticket {
	return &ticket{url, method, code, scopes}
}
func (t *ticket) Method() stream.AuthMethod      { return t.method }
func (t *ticket) AccessCode() stream.OpaqueBytes { return t.code }
func (t *ticket) URL() string                    { return t.url }
func (t *ticket) Scopes() stream.AddressScopes   { return t.scopes }
