package broker

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestTicket(t *testing.T) {
	addr, err := stream.NewAddress(stream.Namespace("nspace"), stream.Version(1), nil)
	require.NoError(t, err)
	scopes := stream.AddressScopes{stream.AnyAddress, addr}
	ticket := NewTicket("url", stream.Reservation, stream.OpaqueBytes("ticket"), scopes)
	assert.Equal(t, stream.Reservation, ticket.Method())
	assert.Equal(t, "url", ticket.URL())
	assert.Equal(t, stream.OpaqueBytes("ticket"), ticket.AccessCode())
	assert.Equal(t, scopes, ticket.Scopes())
}
