package election

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type acceptData map[stream.AddressKey]protocol.Proposal

type acceptMap struct {
	recent  acceptData
	expired acceptData
}

func newAcceptMap() *acceptMap {
	return &acceptMap{
		recent:  make(acceptData),
		expired: make(acceptData),
	}
}

func (a *acceptMap) set(key stream.AddressKey, value protocol.Proposal) {
	a.recent[key] = value
}

func (a *acceptMap) find(key stream.AddressKey) (protocol.Proposal, bool) {
	entry, found := a.recent[key]
	if !found {
		entry, found = a.expired[key]
		if found {
			a.recent[key] = entry // put back into recent since still active
		}
	}
	return entry, found
}

func (a *acceptMap) Expire() error {
	a.expired = a.recent
	a.recent = make(acceptData)
	return nil
}
