package election

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol/message"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestAcceptMap(t *testing.T) {
	src := &testSource{choice: "choice", quorum: 2}

	t.Run("should store values", func(t *testing.T) {
		addr, _ := stream.NewAddress(stream.Namespace("n"), 1, map[string]string{})
		resp, _ := message.NewAccepted(addr, protocol.FirstSuggestion("x"), src.choice)
		key := addr.Key()
		accept := newAcceptMap()
		accept.set(key, resp)

		val, ok := accept.find(key)
		require.True(t, ok)
		assert.Equal(t, resp, val)
	})

	t.Run("should remember values after expire", func(t *testing.T) {
		addr, _ := stream.NewAddress(stream.Namespace("n"), 1, map[string]string{})
		resp, _ := message.NewAccepted(addr, protocol.FirstSuggestion("x"), src.choice)
		key := addr.Key()
		accept := newAcceptMap()
		accept.set(key, resp)

		assert.NoError(t, accept.Expire())

		val, ok := accept.find(key)
		require.True(t, ok)
		assert.Equal(t, resp, val)

		assert.NoError(t, accept.Expire())

		val, ok = accept.find(key)
		require.True(t, ok)
		assert.Equal(t, resp, val)
	})

	t.Run("should clear values after prolonged inactivity", func(t *testing.T) {
		addr, _ := stream.NewAddress(stream.Namespace("n"), 1, map[string]string{})
		resp, _ := message.NewAccepted(addr, protocol.FirstSuggestion("x"), src.choice)
		key := addr.Key()
		accept := newAcceptMap()
		accept.set(key, resp)

		assert.NoError(t, accept.Expire())
		assert.NoError(t, accept.Expire())

		val, ok := accept.find(key)
		require.False(t, ok)
		assert.Nil(t, val)
	})
}
