package election

import (
	"sync"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol/message"
)

type Learner interface {
	Expirable
	OnAccepted(message.Accepted) error
}

type learner struct {
	choices *choiceMap
	mutex   sync.Mutex
}

func NewLearner(data DataSource) Learner {
	return &learner{choices: newChoiceMap(data)}
}

func (l *learner) Expire() error {
	l.mutex.Lock()
	err := l.choices.Expire()
	l.mutex.Unlock()
	return err
}

func (l *learner) OnAccepted(msg message.Accepted) error {
	l.mutex.Lock()
	value, ok := l.choices.add(msg)
	l.mutex.Unlock()
	if ok {
		l.choices.source.OnChosen(msg.Address(), value)
	}
	return nil
}
