package election

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol/message"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestLearner(t *testing.T) {
	t.Run("reports choices properly to data source", func(t *testing.T) {
		hasChosen := false
		src := &testSource{choice: "choice", quorum: 2, chosen: func(stream.Address, string) {
			hasChosen = true
		}}
		addr, _ := stream.NewAddress(stream.Namespace("n"), 1, map[string]string{})
		accepted, _ := message.NewAccepted(addr, protocol.FirstSuggestion("x"), src.choice)
		l := NewLearner(src)
		l.OnAccepted(accepted)
		assert.False(t, hasChosen)
		l.OnAccepted(accepted)
		assert.True(t, hasChosen)
	})

	t.Run("expires choices properly", func(t *testing.T) {
		hasChosen := false
		src := &testSource{choice: "choice", quorum: 2, chosen: func(stream.Address, string) {
			hasChosen = true
		}}
		addr, _ := stream.NewAddress(stream.Namespace("n"), 1, map[string]string{})
		accepted, _ := message.NewAccepted(addr, protocol.FirstSuggestion("x"), src.choice)
		l := NewLearner(src)
		l.OnAccepted(accepted)
		assert.False(t, hasChosen)
		l.Expire()
		l.Expire()
		l.OnAccepted(accepted)
		assert.False(t, hasChosen)
		l.OnAccepted(accepted)
		assert.True(t, hasChosen)
	})
}
