package election

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

// SuggestionMap is used by Acceptors and rejects any suggestion id smaller than
// one it has seen for a given address

type suggestionData map[stream.AddressKey]protocol.SuggestionID

type suggestionMap struct {
	recent  suggestionData
	expired suggestionData
}

var _ Expirable = (*suggestionMap)(nil)

func newSuggestionMap() *suggestionMap {
	return &suggestionMap{
		recent:  make(suggestionData),
		expired: make(suggestionData),
	}
}

func (s *suggestionMap) allow(addr stream.Address, id protocol.SuggestionID) bool {
	if prev, ok := s.find(addr.Key()); ok {
		return !id.Less(prev)
	}
	return true
}

func (s *suggestionMap) set(addr stream.Address, id protocol.SuggestionID) bool {
	key := addr.Key()
	if prev, ok := s.find(key); ok && id.Less(prev) {
		return false
	}
	s.recent[key] = id
	return true
}

func (s *suggestionMap) find(key stream.AddressKey) (protocol.SuggestionID, bool) {
	id, found := s.recent[key]
	if !found {
		id, found = s.expired[key]
		if found {
			s.recent[key] = id
		}
	}
	return id, found
}

func (s *suggestionMap) Expire() error {
	s.expired = s.recent
	s.recent = make(suggestionData)
	return nil
}
