package election

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"github.com/stretchr/testify/assert"
)

func TestSuggestionMap(t *testing.T) {
	t.Run("should reject lower values", func(t *testing.T) {
		addr, _ := stream.NewAddress(stream.Namespace("n"), 1, map[string]string{})
		low := protocol.FirstSuggestion("x")
		mid := low.Next()
		high := mid.Next()

		s := newSuggestionMap()
		assert.True(t, s.allow(addr, low))
		assert.True(t, s.allow(addr, mid))
		assert.True(t, s.allow(addr, high))

		assert.True(t, s.set(addr, low))
		assert.True(t, s.allow(addr, low))
		assert.True(t, s.allow(addr, mid))
		assert.True(t, s.allow(addr, high))

		assert.True(t, s.set(addr, high))
		assert.False(t, s.allow(addr, low))
		assert.False(t, s.allow(addr, mid))
		assert.True(t, s.allow(addr, high))

		assert.False(t, s.set(addr, mid))
	})

	t.Run("should clear values after prolonged inactivity", func(t *testing.T) {
		addr, _ := stream.NewAddress(stream.Namespace("n"), 1, map[string]string{})
		low := protocol.FirstSuggestion("x")
		high := low.Next()

		s := newSuggestionMap()
		assert.True(t, s.set(addr, high))

		assert.NoError(t, s.Expire()) // move to expired, still present

		assert.False(t, s.allow(addr, low))
		assert.True(t, s.allow(addr, high))

		assert.NoError(t, s.Expire()) // move to expired (again), still present

		assert.False(t, s.allow(addr, low))
		assert.True(t, s.allow(addr, high))

		assert.NoError(t, s.Expire()) // clear entirely
		assert.NoError(t, s.Expire())

		assert.True(t, s.allow(addr, low))
		assert.True(t, s.allow(addr, high))
	})
}
