package host

import "code.justin.tv/devhub/e2ml/libs/stream"

// hostAuthorizationPromise is used to store initialization of the host connection inside the
// standard request map so that standard timeout processing can be applied without a special
// case
type hostAuthorizationPromise struct {
	binding *binding
}

var _ stream.MutableCredentialsPromise = (*hostAuthorizationPromise)(nil)

func (*hostAuthorizationPromise) WouldBlock() bool          { return false }
func (*hostAuthorizationPromise) Get() (interface{}, error) { return nil, stream.ErrNotImplemented }
func (*hostAuthorizationPromise) Result() (stream.Credentials, error) {
	return nil, stream.ErrNotImplemented
}

func (h *hostAuthorizationPromise) Set(c stream.Credentials, err error) {
	h.binding.initRequestCallback(err)
}
