package host

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol/message"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type queuedMsgs map[protocol.AckID]message.Validate
type requestData map[protocol.AckID]stream.MutableCredentialsPromise
type requestMap struct {
	queued queuedMsgs
	recent requestData
	old    requestData
}

func newRequestMap() *requestMap {
	return &requestMap{make(queuedMsgs), make(requestData), make(requestData)}
}

func (v *requestMap) add(req protocol.AckID, promise stream.MutableCredentialsPromise) {
	v.recent[req] = promise
}

func (v *requestMap) queue(msg message.Validate) {
	v.queued[msg.AckID()] = msg
}

func (v *requestMap) onFinishInit() queuedMsgs {
	prev := v.queued
	v.queued = make(queuedMsgs)
	return prev
}

func (v *requestMap) remove(req protocol.AckID) (stream.MutableCredentialsPromise, bool) {
	delete(v.queued, req)
	if p, ok := v.recent[req]; ok {
		delete(v.recent, req)
		return p, true
	}
	if p, ok := v.old[req]; ok {
		delete(v.old, req)
		return p, true
	}
	return nil, false
}

func (v *requestMap) tick() requestData {
	prev := v.old
	v.old = v.recent
	v.recent = make(requestData)
	for req := range prev {
		delete(v.queued, req)
	}
	return prev
}
