package protocol

// RequestID is used to track ack or nack of individual requests; it is designed
// to have a short validity and the same value may be reused over time. Clients
// should explire association on a timeout and treat unacknowleged sigals as
// failures. Since the value is used for client tracking, collisions across
// clients are virtually guaranteed and this should always be stored with a
// unique client identifier or connection on the service side.
type AckID uint16

const (
	NoAckID    = AckID(0) // zero value is not a valid request id; forces assignment
	FirstAckID = AckID(1)
)

// Next allows a safe sequence that wraps without ever returning NoRequest
func (r AckID) Next() AckID { return r + 2 }

// IsValid returns true if this is a valid RequestID
func (r AckID) IsValid() bool { return r != NoAckID }
