package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestConnect(t *testing.T) {
	token := OpaqueBytes("Admit One")

	t.Run("should report values correctly", func(t *testing.T) {
		conn, err := NewConnect(protocol.Current, token)
		require.NoError(t, err)
		assert.Equal(t, protocol.Connect, conn.OpCode())
		assert.Equal(t, protocol.Current, conn.Version())
		assert.Equal(t, token, conn.Token())
		assert.Equal(t, "<connect> version=2, ####", conn.String())
	})

	t.Run("should marshal correctly", func(t *testing.T) {
		conn, err := NewConnect(protocol.Current, token)
		require.NoError(t, err)
		bytes, err := conn.Marshal(protocol.Current)
		require.NoError(t, err)
		out, err := Unmarshal(bytes)
		require.NoError(t, err)
		assert.Equal(t, conn, out)
	})

	t.Run("should report version errors", func(t *testing.T) {
		_, err := NewConnect(protocol.Unknown, token)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		_, err = createBlank(protocol.Connect).Marshal(protocol.Unknown)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		assert.Equal(t, protocol.ErrInvalidVersion, createBlank(protocol.Connect).Unmarshal(protocol.Unknown, []byte{}))
	})

	t.Run("should report length errors", func(t *testing.T) {
		assert.Equal(t, protocol.ErrInvalidLength(connectTokenOffset, 0),
			createBlank(protocol.Connect).Unmarshal(protocol.Current, []byte{}))
	})
}
