package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestFailure(t *testing.T) {
	t.Run("should report values correctly", func(t *testing.T) {
		msg, err := NewFailure(protocol.FirstRequestID, protocol.ErrInvalidHeader)
		require.NoError(t, err)
		assert.Equal(t, protocol.Failure, msg.OpCode())
		assert.Equal(t, protocol.FirstRequestID, msg.ForRequestID())
		assert.EqualError(t, msg, protocol.ErrInvalidHeader.Error())
		assert.Equal(t, "<failure> reqID=1, err=Invalid header", msg.String())
	})

	t.Run("should report invalid request id", func(t *testing.T) {
		msg, err := NewFailure(protocol.NoRequestID, protocol.ErrInvalidHeader)
		assert.Nil(t, msg)
		assert.Equal(t, protocol.ErrInvalidRequestID, err)
	})

	t.Run("should marshal correctly", func(t *testing.T) {
		join, err := NewFailure(protocol.FirstRequestID, nil)
		require.NoError(t, err)
		bytes, err := join.Marshal(protocol.Current)
		require.NoError(t, err)
		out, err := Unmarshal(bytes)
		require.NoError(t, err)
		assert.Equal(t, join, out)
	})

	t.Run("should report version errors", func(t *testing.T) {
		_, err := createBlank(protocol.Failure).Marshal(protocol.Unknown)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		assert.Equal(t, protocol.ErrInvalidVersion, createBlank(protocol.Failure).Unmarshal(protocol.Unknown, []byte{}))
	})

	t.Run("should report length errors", func(t *testing.T) {
		assert.Equal(t, protocol.ErrInvalidLength(errorMessageOffset, 0),
			createBlank(protocol.Failure).Unmarshal(protocol.Current, []byte{}))
	})
}
